<cfcomponent extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO
-- Inserir um item de movimentao de container
-- ricardocabral 22/01/2016 09:05:51 - CRIADO
--->
<cffunction name='ins_movto_container_it' displayname='Inserir um item de movimentao de container' access='remote' returntype='Struct' output='true'>
	<cfargument name='MOVTO_CONTAINER_ID' required='yes'>
	<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
	<cfargument name='ENTREGUE' required="no" default="0">
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='multimodal.pkg_controle.prc_ins_movto_container_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MOVTO_CONTAINER_IT_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOVTO_CONTAINER_ID#'  null='#iif(len(trim(arguments.MOVTO_CONTAINER_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENTREGUE#'  null='#iif(len(trim(arguments.ENTREGUE)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Inserir uma movimentao de container
-- ricardocabral 21/01/2016 17:46:55 - CRIADO
--->
<cffunction name='consolidar_container' displayname='Inserir uma movimentao de container' access='remote' returntype='Struct' output='true'>
	<cfargument name='CARGA_CONSOLIDADA_ID' required='yes'>
	<cfargument name='CONTAINER_ID' required='yes'>
	<cfargument name='LACRE' required='no' default=''>
	<cfargument name='BOOKING_ID' required='no' default=''>
	<cfargument name='MODALIDADE_CARGA_ID' required='no' default=''>
	<cfargument name='MASTER_BL' required='no' default=''>
	<cfargument name='HOUSE_BL' required='no' default=''>
	<cfargument name='COD_PESSOA_DEPOT' required='no' default=''>
	<cfargument name='DATA_INICIO_UTILIZACAO' required='no' default=''>
	<cfargument name='DATA_DEVOLUCAO_PREVISTA' required='no' default=''>
	<cfargument name='DATA_FREE_TIME' required='no' default=''>
	<cfargument name='PORTO_ID_ORIGEM' required='no' default=''>
	<cfargument name='PORTO_ID_DESTINO' required='no' default=''>
	<cfargument name='COD_PESSOA_ARMADOR' required='no' default=''>
	<cfargument name='COD_PESSOA_DESPACHANTE' required='no' default=''>
	<cfargument name='NAVIO' required='no' default=''>
	<cfargument name='OBSERVACAO' required='no' default=''>
	<cfargument name='ORIGEM_REGISTRO' required='yes'>
	<cfargument name='MOVTO_CONTAINER_ID_ANTERIOR' required='no' default=''>
	<cfargument name='TIPO_ORIGEM_DESTINO_ID' required='no' default=''>
	<cfargument name='NUMERO_OS' required='no' default=''>
	<cfargument name='CONTAINER_VAZIO' required='no' default=''>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='multimodal.pkg_controle.prc_consolidar_container' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_CONSOLIDADA_ID#'  null='#iif(len(trim(arguments.CARGA_CONSOLIDADA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTAINER_ID#'  null='#iif(len(trim(arguments.CONTAINER_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LACRE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BOOKING_ID#'  null='#iif(len(trim(arguments.BOOKING_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODALIDADE_CARGA_ID#'  null='#iif(len(trim(arguments.MODALIDADE_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MASTER_BL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.HOUSE_BL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_DEPOT#'  null='#iif(len(trim(arguments.COD_PESSOA_DEPOT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO_UTILIZACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_DEVOLUCAO_PREVISTA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FREE_TIME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PORTO_ID_ORIGEM#'  null='#iif(len(trim(arguments.PORTO_ID_ORIGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PORTO_ID_DESTINO#'  null='#iif(len(trim(arguments.PORTO_ID_DESTINO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_ARMADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_ARMADOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_DESPACHANTE#'  null='#iif(len(trim(arguments.COD_PESSOA_DESPACHANTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NAVIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORIGEM_REGISTRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOVTO_CONTAINER_ID_ANTERIOR#'  null='#iif(len(trim(arguments.MOVTO_CONTAINER_ID_ANTERIOR)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MOVTO_CONTAINER_ID_GERADO' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORIGEM_DESTINO_ID#'  null='#iif(len(trim(arguments.TIPO_ORIGEM_DESTINO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO_OS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTAINER_VAZIO#'  null='#iif(len(trim(arguments.CONTAINER_VAZIO)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Movimentao inserida com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Inserir um container
-- ricardocabral 21/01/2016 17:35:05 - CRIADO
--->
<cffunction name='ins_container_identificador' displayname='Inserir um container' access='remote' returntype='Struct' output='true'>
	<cfargument name='IDENTIFICADOR' required='yes'>
	<cfargument name='TIPO_ID' required='yes'>
	<cfargument name='TARA' required='no' default="">
	<cfargument name='PESO_BRUTO_MAX' required='no' default="">
	<cfargument name='REFERENCIA_ID' required='no' default="">
	<cfargument name='CONTAINER_SITUACAO_ID' required='no' default="">
	<cfargument name='OBSERVACAO' required='no' default="">
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='multimodal.pkg_cadastro.prc_ins_container' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTAINER_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.IDENTIFICADOR#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TARA#'  null='#iif(len(trim(arguments.TARA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_BRUTO_MAX#'  null='#iif(len(trim(arguments.PESO_BRUTO_MAX)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTAINER_SITUACAO_ID#'  null='#iif(len(trim(arguments.CONTAINER_SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Container inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Altera a situao de uma solicitao
    -- cristofer 15/04/2009 17:34:23 - CRIADO
    --->
    <cffunction name='upd_solicitacao_situacao' displayname='Altera a situao de uma solicitao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicitacao_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                
                <cfscript>
					ret = this.set_solicitacao_carga_comp(solicitacao_carga_id = arguments.solicitacao_carga_id,
														  composicao = arguments.composicao);
                </cfscript>
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Situao alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    

	<!--- 
    -- PROPSITO
    -- Altera a situao de uma solicitao
    -- cristofer 15/04/2009 17:34:23 - CRIADO
    --->
    <cffunction name='upd_solicitacao_baixa' displayname='Altera a situao de uma solicitao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DATA_CARREGAMENTO_REALIZADO' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cfargument name='COD_MOTORISTA' required='no' default="">
        <cfargument name='COD_PROPRIETARIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicitacao_baixa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARREGAMENTO_REALIZADO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfscript>
					if(arguments.situacao_id eq 6)
						arguments.composicao = '';
					ret = this.set_solicitacao_carga_comp(solicitacao_carga_id = arguments.solicitacao_carga_id,
														  composicao = arguments.composicao);
                </cfscript>
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Situao alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um veiculo na composicao da solicitacao
    -- cristofer 15/04/2009 17:36:59 - CRIADO
    --->
    <cffunction name='ins_solicitacao_carga_comp' displayname='Insere um veiculo na composicao da solicitacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='VEICULO_ID' required='yes'>
        <cfargument name='ORDEM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_carga_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veiculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um veiculo da composicao da solicitacao
    -- cristofer 15/04/2009 17:37:30 - CRIADO
    --->
    <cffunction name='del_solicitacao_carga_comp' displayname='Exclui um veiculo da composicao da solicitacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_solicitacao_carga_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veiculo excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera a composicao da solicitacao
    -- cristofer 15/04/2009 17:47:10 - CRIADO
    --->
    <cffunction name='set_solicitacao_carga_comp' displayname='Altera a composicao da solicitacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cfargument name='VALIDA_VEICULO' required='no' default="0">
        <cftry>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_set_solicitacao_carga_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPOSICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALIDA_VEICULO#'  null='#iif(len(trim(arguments.VALIDA_VEICULO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composicao alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
        
    <!--- 
    -- PROPSITO
    -- Insere uma solicitacao de carga
    -- cristofer 12/05/2009 17:55:38 - CRIADO
    --->
    <cffunction name='ins_solicitacao_carga' displayname='Insere uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
        <cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA_CARREGAMENTO_INICIO' required='yes'>
        <cfargument name='DATA_CARREGAMENTO_FIM' required='yes'>
        <cfargument name='DATA_ENTREGA_INICIO' required='yes'>
        <cfargument name='DATA_ENTREGA_FIM' required='yes'>
        <cfargument name='VALOR_EM' required='yes'>
        <cfargument name='PESO' required='yes'>
        <cfargument name='M3' required='yes'>
        <cfargument name='QTDE_VOLUME' required='yes'>
        <cfargument name='PESO_VOLUME' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_CONSIGNATARIO' required='yes'>
        <cfargument name='COD_REDESPACHO' required='yes'>
        <cfargument name='COD_COBRANCA' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='NUM_ESPECIE' required='yes'>
        <cfargument name="MATERIAL_ID" required='no' default=''>
        <cfargument name="TIPO_CARROCERIA_ID" required='no' default=''>
        <cfargument name="NF_NUMERO" required='no' default=''>
        <cfargument name="NF_DATA_EMISSAO" required='no' default=''>
        <cfargument name="COD_MOTORISTA" required='yes'>
        <cfargument name='VALOR_TOTAL_SUGERIDO' required='yes'>
        <cfargument name="COMPOSICAO" required='yes'>
        <cfargument name="LIBERADA_AGENDAMENTO" required='yes'>
        <cfargument name='GERA_ROMANEIO' required='no' default='0'>
        <cfargument name='CARTAO_NUMERO' required='no' default=''>
        <cfargument name='ADTO_TRAJETO_VAZIO' required='no' default=''>
        <cfargument name='TIPO_DOCUMENTO_ID' required='no' default='1'>
        <cfargument name='SOLICITACAO_CARGA_ID_VINCULO' required='no' default=''>
        <cfargument name='PRIORIDADE' required='no' default=''>
        <cfargument name='INTC_CONHECIMENTO_ID' required='no' default=''>    
        <cfargument name='PEDIDO_SHIPMENT' required='no' default=''>
        <cfargument name='PRE_ORDEM_ID' required='no' default="">
        <cfargument name='ENDERECO_COMBO_REMETENTE' required="no" default=''>
        <cfargument name='ENDERECO_COMBO_DESTINATARIO' required="no" default=''>
        <cfargument name='ENDERECO_COMBO_CONSIGNATARIO' required="no" default=''>
        <cfargument name='ENDERECO_COMBO_REDESPACHO' required="no" default=''>
        <cfargument name='ENDERECO_COMBO_COBRANCA' required="no" default=''>
		<cfargument name='ETIQUETA_ID' required="no" default=''>
		<cfargument name='LOTE_ID' required="no" default=''>
        <cftry>
			<cfscript>
				if (arguments.ENDERECO_COMBO_CONSIGNATARIO eq -1)
				   arguments.ENDERECO_COMBO_CONSIGNATARIO = '';

				if (arguments.ENDERECO_COMBO_REDESPACHO eq -1)
				   arguments.ENDERECO_COMBO_REDESPACHO = '';
	
				if (arguments.ENDERECO_COMBO_COBRANCA eq -1)
				   arguments.ENDERECO_COMBO_COBRANCA = '';
	
				if (arguments.ENDERECO_COMBO_DESTINATARIO eq -1)
				   arguments.ENDERECO_COMBO_DESTINATARIO = '';
	
				if (arguments.ENDERECO_COMBO_REMETENTE eq -1)
				   arguments.ENDERECO_COMBO_REMETENTE = ''; 
            </cfscript>      
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_CARGA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_NATUREZA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARREGAMENTO_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARREGAMENTO_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR_EM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_VOLUME#'  null='#iif(len(trim(arguments.PESO_VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_COBRANCA#'  null='#iif(len(trim(arguments.COD_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_TOTAL_SUGERIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LIBERADA_AGENDAMENTO#'  null='#iif(len(trim(arguments.LIBERADA_AGENDAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PEDIDO_SHIPMENT#' >
                    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_CONSIGNATARIO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_CONSIGNATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_REDESPACHO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_REDESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_COBRANCA#' null='#iif(len(trim(arguments.ENDERECO_COMBO_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_DESTINATARIO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_REMETENTE#' null='#iif(len(trim(arguments.ENDERECO_COMBO_REMETENTE)), de('no'), de('yes'))#'>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.LOTE_ID#' null='#iif(len(trim(arguments.LOTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!---Vnculo da solicitao de carga com a pr-ordem --->
                <cfif Len(Trim(arguments.PRE_ORDEM_ID))>
                	<cfscript>
						ret_preordem = this.ins_pre_ordem_sol_carga(pre_ordem_id         = arguments.PRE_ORDEM_ID
						                                           ,solicitacao_carga_id = retorno.SOLICITACAO_CARGA_ID);
					</cfscript>
                    <cfif ret_preordem.erro>
                    	<cfthrow object="#ret_preordem.mensagem#">
                    </cfif>
                </cfif>
                
                <!--- Composio --->
                <cfif Len(Trim(arguments.COMPOSICAO))>
                	<cfscript>
						ret_comp = this.set_solicitacao_carga_comp(solicitacao_carga_id = retorno.SOLICITACAO_CARGA_ID,
															  	   composicao 		    = arguments.COMPOSICAO,
															  	   valida_veiculo 	    = 1);
					</cfscript>
                    <cfif ret_comp.erro>
                    	<cfthrow object="#ret_comp.mensagem#">
                    </cfif>
                </cfif>
                
                <cfswitch expression="#arguments.tipo_documento_id#">
                        <cfcase value="0">
                            <!--- Insere Notas fiscais --->
                            <cfscript>
                                v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_NOTAS_FISCAIS');
								v_nota_conhecimento  = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NOTAS_FISCAIS");
                                v_numero 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_NUMERO_NOTAS_FISCAIS");
                                v_data_emissao       = this.ListaToArray(lista = arguments, variavel  = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                                v_serie 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_SERIE_NOTAS_FISCAIS");
                                v_sub_serie          = this.ListaToArray(lista = arguments, variavel  = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                                v_modelo             = this.ListaToArray(lista = arguments, variavel  = "NOTA_MODELO_NOTAS_FISCAIS");
                                v_valor		         = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_NOTAS_FISCAIS");
                                v_valor_segurado     = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
                                v_peso               = this.ListaToArray(lista = arguments, variavel  = "NOTA_PESO_NOTAS_FISCAIS");
                                v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
                                v_qtde_volume        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
                                v_cod_unidade        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
                                v_m3                 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_M3_NOTAS_FISCAIS');
                                v_peso_cubado        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
                                v_num_natureza       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
                                v_natureza           = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NATUREZA_NOTAS_FISCAIS');
                                v_complemento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
                                v_num_especie        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
                                v_especie            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ESPECIE_NOTAS_FISCAIS');
                                v_altura             = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ALTURA_NOTAS_FISCAIS');
                                v_largura            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_LARGURA_NOTAS_FISCAIS');
                                v_comprimento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
                                v_cubagem            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
                                v_cfop				 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CFOP_NOTAS_FISCAIS');
                                v_ordem_compra       = this.ListaToArray(lista = arguments, variavel  = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");								
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                                <cfscript>
                                    ret_nf = this.ins_solicitacao_carga_nf(SOLICITACAO_CARGA_ID 			= retorno.SOLICITACAO_CARGA_ID,
																		 numero							= v_numero[count],
																		 data_emissao					= v_data_emissao[count],
																		 modelo							= v_modelo[count],
																		 serie							= v_serie[count],
																		 sub_serie						= v_sub_serie[count],
																		 valor_total					= v_valor[count],
																		 nf_eletronica					= 0 ,
																		 valor_segurado					= v_valor_segurado[count],
																		 ordem_compra_cliente			= v_ordem_compra[count],
																		 peso							= v_peso[count],
																		 peso_cubado					= v_peso_cubado[count],
																		 peso_cobrado					= v_peso_cobrado[count],
																		 qtde_volume					= v_qtde_volume[count],
																		 altura							= v_altura[count],
																		 comprimento					= v_comprimento[count],
																		 largura						= v_largura[count],
																		 m3								= v_m3[count],
																		 cubagem						= v_cubagem[count],
																		 num_natureza					= v_num_natureza[count],
																		 complemento					= '',
																		 num_especie					= v_num_especie[count],
																		 cod_unidade					= v_cod_unidade[count],
																		 tipo_documento_id				= arguments.tipo_documento_id,
																		 num_romaneio					= '',
																		 valor_base_calculo_icms		= '',
																		 valor_icms						= '',
																		 valor_base_calculo_icms_st		= '',
																		 valor_icms_st					= '',
																		 valor_produtos					= '',
																		 cfop							= v_cfop[count],
																		 pin_suframa					= '',
																		 chave_acesso_nfe				= '',
																		 descricao_docto				= '',
																		 nfe_xml						= '');
                                </cfscript>
                                <cfif ret_nf.erro>
                                    <cfthrow object="#ret_nf.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>
                        
                        <cfcase value="1">
                            <!--- Insere NFE --->
                            <cfscript>
                                v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_NFE');
								v_nota_conhecimento     = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NFE");
                                v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                                v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
								v_nfe_valor_segurado	= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_SEGURADO");
                                v_pin_suframa_nfe		= this.ListaToArray (lista = arguments, variavel = "PIN_SUFRAMA_NFE_NFE");
                                v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                                v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                                v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                                v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                                v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                                v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
                                v_peso               	= this.ListaToArray(lista = arguments, variavel  = "NFE_PESO_NFE");
                                v_peso_cobrado       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_COBRADO_NFE');
                                v_qtde_volume        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_QTDE_VOLUME_NFE');
                                v_cod_unidade        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COD_UNIDADE_NFE');
                                v_m3                 	= this.ListaToArray(lista = arguments, variavel  = 'NFE_M3_NFE');
                                v_peso_cubado        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_CUBADO_NFE');
                                v_num_natureza       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_NATUREZA_NFE');
                                v_natureza           	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NATUREZA_NFE');
                                v_num_especie        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_ESPECIE_NFE');
                                v_especie            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ESPECIE_NFE');
                                v_altura             	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ALTURA_NFE');
                                v_largura            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_LARGURA_NFE');
                                v_comprimento        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COMPRIMENTO_NFE');
                                v_cubagem            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_CUBAGEM_NFE');
                                v_ordem_compra       	= this.ListaToArray(lista = arguments, variavel  = "NFE_ORDEM_COMPRA_NFE");
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                                <!--- Busca arquivo --->
                                <cfif Len(Trim(v_nome_arquivo[count]))>
                                    <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                                <cfelse>
                                    <cfset VARQUIVO = ''>
                                </cfif>
                                
                                <cfscript>
                                    ret_nfe = this.ins_solicitacao_carga_nf(SOLICITACAO_CARGA_ID 			= retorno.SOLICITACAO_CARGA_ID,
                                                              numero						= v_numero[count],
                                                              numero_old					= v_numero[count],
                                                              data_emissao					= v_data_emissao[count],
                                                              modelo						= v_modelo[count],
                                                              serie							= v_serie[count],
                                                              sub_serie						= '1',
                                                              valor_total					= v_nfe_valor[count],
                                                              nf_eletronica					= 1,
                                                              valor_segurado				= v_nfe_valor_segurado[count],
                                                              ordem_compra_cliente			= v_ordem_compra[count],
                                                              peso							= v_peso[count],
                                                              peso_cubado					= v_peso_cubado[count],
                                                              peso_cobrado					= v_peso_cobrado[count],
                                                              qtde_volume					= v_qtde_volume[count],
                                                              altura						= v_altura[count],
                                                              comprimento					= v_comprimento[count],
                                                              largura						= v_largura[count],
                                                              m3							= v_m3[count],
                                                              cubagem						= v_cubagem[count],
                                                              num_natureza					= v_num_natureza[count],
                                                              complemento					= '',
                                                              num_especie					= v_num_especie[count],
                                                              cod_unidade					= v_cod_unidade[count],
                                                              tipo_documento_id				= arguments.tipo_documento_id,
                                                              num_romaneio					= '',
                                                              valor_base_calculo_icms		= '',
                                                              valor_icms					= '',
                                                              valor_base_calculo_icms_st	= '',
                                                              valor_icms_st					= '',
                                                              valor_produtos				= '',
                                                              cfop							= '',
                                                              pin_suframa					= v_pin_suframa_nfe[count],
                                                              chave_acesso_nfe				= v_chave_acesso_nfe[count],
                                                              descricao_docto				= '',
                                                              nfe_xml						= VARQUIVO,
                                                              documento_id					= v_documento_id[count]);
                                </cfscript>
                                <cfif ret_nfe.erro>
                                    <cfthrow object="#ret_nfe.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>


                        <cfcase value="2">
                            <!--- Insere Outros Documentos--->
                            <cfscript>
                                v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_OUTROS');
								v_nota_conhecimento  	  = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_OUTROS");
                                v_outros_numero			  = this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                                v_outros_data_emissao	  = this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                                v_outros_descricao		  = this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                                v_outros_valor			  = this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                                v_peso                    = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                                v_peso_cobrado            = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                                v_qtde_volume             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                                v_cod_unidade             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                                v_m3                      = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                                v_peso_cubado             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                                v_num_natureza            = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                                v_complemento             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                                v_num_especie             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                                v_altura                  = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                                v_largura                 = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                                v_comprimento             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                                v_cubagem                 = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
								v_ordem_compra       	  = this.ListaToArray(lista = arguments, variavel  = "OUTROS_ORDEM_COMPRA_OUTROS");
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                                <cfscript>
                                    outros = this.ins_solicitacao_carga_nf(SOLICITACAO_CARGA_ID 			= retorno.SOLICITACAO_CARGA_ID,
                                                             numero							= v_outros_numero[count],
                                                             numero_old						= v_outros_numero[count],
                                                             data_emissao					= v_outros_data_emissao[count],
                                                             modelo							= '01',
                                                             serie							= 'U',
                                                             sub_serie						= '1',
                                                             valor_total					= v_outros_valor[count],
                                                             nf_eletronica					= 0,
                                                             valor_segurado					= v_outros_valor[count],
                                                             ordem_compra_cliente			= v_ordem_compra[count],
                                                             peso							= v_peso[count],
                                                             peso_cubado					= v_peso_cubado[count],
                                                             peso_cobrado					= v_peso_cobrado[count],
                                                             qtde_volume					= v_qtde_volume[count],
                                                             altura							= v_altura[count],
                                                             comprimento					= v_comprimento[count],
                                                             largura						= v_largura[count],
                                                             m3								= v_m3[count],
                                                             cubagem						= v_cubagem[count],
                                                             num_natureza					= v_num_natureza[count],
                                                             complemento					= '',
                                                             num_especie					= v_num_especie[count],
                                                             cod_unidade					= v_cod_unidade[count],
                                                             tipo_documento_id				= arguments.tipo_documento_id,
                                                             num_romaneio					= '',
                                                             valor_base_calculo_icms		= '',
                                                             valor_icms						= '',
                                                             valor_base_calculo_icms_st		= '',
                                                             valor_icms_st					= '',
                                                             valor_produtos					= '',
                                                             cfop							= '',
                                                             pin_suframa					= '',
                                                             chave_acesso_nfe				= '',
                                                             descricao_docto				= v_outros_descricao[count],
                                                             nfe_xml						= '');
                                </cfscript>
                                <cfif outros.erro>
                                    <cfthrow object="#outros.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>                
                    </cfswitch>
                    
                <!---- VINCULA O CRT a Solicitao de carga ----->
                <cfif Len(Trim(arguments.INTC_CONHECIMENTO_ID))>
                	<cfscript>
						ret_vinculo_crt = this.vincula_solicitacao_crt(solicitacao_carga_id         = retorno.SOLICITACAO_CARGA_ID,
 			  							                               conhecimento_id		        = arguments.INTC_CONHECIMENTO_ID);
					</cfscript>
					<cfif ret_vinculo_crt.erro>
                        <cfthrow object="#ret_vinculo_crt.mensagem#">
                    </cfif>
                </cfif>
                
                
                <!--- Liberada p/ Agendamento --->
                <cfif arguments.LIBERADA_AGENDAMENTO eq 1>
                	<cfscript>
						ret_agen = this.liberar_agendamento_solic_carga(solicitacao_carga_id         = retorno.SOLICITACAO_CARGA_ID,
																	    gera_agendamento_auto		 = 1,
						  										        gera_romaneio		         = arguments.GERA_ROMANEIO,
																        solicitacao_carga_id_vinculo = arguments.SOLICITACAO_CARGA_ID_VINCULO);
					</cfscript>
                <cfelse>
                	<cfscript>
						ret_agen = this.estornar_agendamento_solic_carga(solicitacao_carga_id = retorno.SOLICITACAO_CARGA_ID);
					</cfscript>
                </cfif>
                <cfif ret_agen.erro>
                    <cfthrow object="#ret_agen.mensagem#">
                </cfif>
                
                <!--- Verificar dados junto a Repom --->
                <cfscript>
				
					conn = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
					if (Len(Trim(conn.get_versao_repom())) )
				  		conn_repom = CreateComponent("modulos.repom._componentes.manipulacao.cfc_repom");					
					else
						conn_repom = CreateComponent("_transportes.manipulacao.transporte.cfc_repom");					
								   				
					ret_sol_rep = conn_repom.ins_solicit_carga_dados(solicitacao_carga_id = retorno.solicitacao_carga_id
														     	    ,cartao_numero	      = arguments.CARTAO_NUMERO
															 	   	,adto_trajeto_vazio   = arguments.ADTO_TRAJETO_VAZIO
															  		);
				</cfscript>
                <cfif ret_sol_rep.erro>
                    <cfthrow object="#ret_sol_rep.mensagem#">
                </cfif>
                
                <!--- Container <ins> --->
                <cfscript>
					v_container_id = -1;
               	</cfscript>
				<cfif arguments.POSSUI_MOVTO_CONTAINER eq 0 > <!--- No possui movimentao --->
    	           	<cfif not len(trim(arguments.CONTAINER_ID)) > <!--- No foi informado um container do sistema --->
	    	           	<cfif len(trim(arguments.CONTAINER_IDENTIFICADOR)) > <!--- Foi informado um container desconhecido. Cadastrar --->
            	        	<cfscript>
								ret_cad_ctn = ins_container_identificador(identificador = arguments.CONTAINER_IDENTIFICADOR
								                                         ,tipo_id		= arguments.CONTAINER_TIPO_ID);
							</cfscript>
							<cfif ret_cad_ctn.erro>
	                            <cfthrow object="#ret_cad_ctn.mensagem#">
                            <cfelse>
	                            <cfset v_container_id = ret_cad_ctn.CONTAINER_ID>
                            </cfif>
						</cfif>
					<cfelse> <!--- Foi informado um container do sistema --->
						<cfset v_container_id = arguments.CONTAINER_ID>
					</cfif>
					<cfif len(trim(v_container_id)) and v_container_id gt 0 > <!--- Tendo o container, consolidar e vincular  solicitao de carga: --->
                    	<cfscript>
							ret_cons_ctn = consolidar_container(container_id         = v_container_id
							                                   ,carga_consolidada_id = arguments.CARGA_CONSOLIDADA_ID
												               ,origem_registro 	 = 'Manual');
						</cfscript>
						<cfif ret_cons_ctn.erro>
                            <cfthrow object="#ret_cons_ctn.mensagem#">
                        <cfelse> <!--- Se consolidou o container, vincula --->
                        	<cfscript>
								ret_it_ctn = ins_movto_container_it(movto_container_id   = ret_cons_ctn.MOVTO_CONTAINER_ID_GERADO
								                                   ,solicitacao_carga_id = retorno.SOLICITACAO_CARGA_ID);
							</cfscript>
							<cfif ret_it_ctn.erro>
	                            <cfthrow object="#ret_it_ctn.mensagem#">
                            </cfif>                            
                        </cfif>                        
					</cfif>                            
                </cfif>	<!---<cfif arguments.POSSUI_MOVTO_CONTAINER eq 0 > <!--- No possui movimentao --->--->        

				<!--- Valida situao da solicitao --->
				<cfscript>
					conn = CreateComponent("_transportes.consulta.logistica.cfc_solicitacao");
					qrSolicitacao = conn.get_solicitacao_carga(solicitacao_carga_id	= retorno.SOLICITACAO_CARGA_ID);
				</cfscript>

				<cfset retorno.SITUACAO_ID = qrSolicitacao.SITUACAO_ID>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de carga N ' & retorno.SOLICITACAO_CARGA_ID & ' inserida com sucesso.' & ret_sol_rep.MENSAGEM)>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma solicitacao de carga
    -- ANDERSON - 09/09/2009 - ALTERADO
    --->
    <cffunction name='upd_solicitacao_carga' displayname='Altera uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
        <cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA_CARREGAMENTO_INICIO' required='yes'>
        <cfargument name='DATA_CARREGAMENTO_FIM' required='yes'>
        <cfargument name='DATA_ENTREGA_INICIO' required='yes'>
        <cfargument name='DATA_ENTREGA_FIM' required='yes'>
        <cfargument name='VALOR_EM' required='yes'>
        <cfargument name='PESO' required='yes'>
        <cfargument name='M3' required='yes'>
        <cfargument name='QTDE_VOLUME' required='yes'>
        <cfargument name='PESO_VOLUME' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_CONSIGNATARIO' required='yes'>
        <cfargument name='COD_REDESPACHO' required='yes'>
        <cfargument name='COD_COBRANCA' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='NUM_ESPECIE' required='yes'>
        <cfargument name="MATERIAL_ID" required='no' default=''>
        <cfargument name="TIPO_CARROCERIA_ID" required='no' default=''>
        <cfargument name="NF_NUMERO" required='no' default=''>
        <cfargument name="NF_DATA_EMISSAO" required='no' default=''>
        <cfargument name="COD_MOTORISTA" required='yes'>
        <cfargument name='VALOR_TOTAL_SUGERIDO' required='yes'>
        <cfargument name="COMPOSICAO" required='no' default=''>
        <cfargument name="LIBERADA_AGENDAMENTO" required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='GERA_ROMANEIO' required='no' default='0'>
        <cfargument name='PRIORIDADE' required='no' default=''>        
        <cfargument name='INTC_CONHECIMENTO_ID' required='no' default=''>            
        <cfargument name='PEDIDO_SHIPMENT' required='no' default=''>     
        <cfargument name='ENDERECO_COMBO_REMETENTE' required="no" default=''>
		<cfargument name='ENDERECO_COMBO_DESTINATARIO' required="no" default=''>
		<cfargument name='ENDERECO_COMBO_CONSIGNATARIO' required="no" default=''>
		<cfargument name='ENDERECO_COMBO_REDESPACHO' required="no" default=''>
		<cfargument name='ENDERECO_COMBO_COBRANCA' required="no" default=''>
        <cfargument name='PRE_ORDEM_ID' required="no" default=''>
        <cfargument name='CONTAINER_VAZIO' required="no" default='0'>
        <cfargument name='COD_TRANSPORTADOR_SUGERIDO' required="no" default=''>
		<cfargument name='ETIQUETA_ID' required="no" default=''>
		<cfargument name='LOTE_ID' required="no" default=''>

        <cftry>
			<cfscript>
				if (arguments.ENDERECO_COMBO_CONSIGNATARIO eq -1)
				   arguments.ENDERECO_COMBO_CONSIGNATARIO = '';

				if (arguments.ENDERECO_COMBO_REDESPACHO eq -1)
				   arguments.ENDERECO_COMBO_REDESPACHO = '';
	
				if (arguments.ENDERECO_COMBO_COBRANCA eq -1)
				   arguments.ENDERECO_COMBO_COBRANCA = '';
	
				if (arguments.ENDERECO_COMBO_DESTINATARIO eq -1)
				   arguments.ENDERECO_COMBO_DESTINATARIO = '';
	
				if (arguments.ENDERECO_COMBO_REMETENTE eq -1)
				   arguments.ENDERECO_COMBO_REMETENTE = ''; 
            </cfscript>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicitacao_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_NATUREZA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARREGAMENTO_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CARREGAMENTO_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTREGA_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR_EM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_VOLUME#'  null='#iif(len(trim(arguments.PESO_VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_COBRANCA#'  null='#iif(len(trim(arguments.COD_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NF_DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_TOTAL_SUGERIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>                    
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PEDIDO_SHIPMENT#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_CONSIGNATARIO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_CONSIGNATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_REDESPACHO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_REDESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_COBRANCA#' null='#iif(len(trim(arguments.ENDERECO_COMBO_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_DESTINATARIO#' null='#iif(len(trim(arguments.ENDERECO_COMBO_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ENDERECO_COMBO_REMETENTE#' null='#iif(len(trim(arguments.ENDERECO_COMBO_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.CONTAINER_VAZIO#' null='#iif(len(trim(arguments.CONTAINER_VAZIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_TRANSPORTADOR_SUGERIDO#' null='#iif(len(trim(arguments.COD_TRANSPORTADOR_SUGERIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.LOTE_ID#' null='#iif(len(trim(arguments.LOTE_ID)), de('no'), de('yes'))#'>					
                </cfstoredproc>
                
                <!---Vnculo da solicitao de carga com a pr-ordem --->
                <cfif Len(Trim(arguments.PRE_ORDEM_ID))>
                	<cfscript>
						ret_preordem = this.ins_pre_ordem_sol_carga(pre_ordem_id         = arguments.PRE_ORDEM_ID
						                                           ,solicitacao_carga_id = arguments.SOLICITACAO_CARGA_ID);
					</cfscript>
                    <cfif ret_preordem.erro>
                    	<cfthrow object="#ret_preordem.mensagem#">
                    </cfif>
                <cfelse>
                	<cfscript>
						ret_can_preordem = this.can_pre_ordem_sol_carga(solicitacao_carga_id = arguments.SOLICITACAO_CARGA_ID);
					</cfscript>
                    <cfif ret_can_preordem.erro>
                    	<cfthrow object="#ret_can_preordem.mensagem#">
                    </cfif>
                </cfif>
                
                <cfscript>
					conn = CreateComponent("_transportes.consulta.logistica.cfc_solicitacao");
					qrSolicitacao = conn.get_solicitacao_carga(solicitacao_carga_id	= arguments.SOLICITACAO_CARGA_ID);
				</cfscript>
                
                <!--- Se a SITUACAO_ID for 1 (Em Aberto), altera os dados da composio --->
                
                <cfif (qrSolicitacao.SITUACAO_ID eq 1 and qrSolicitacao.LIBERADA_AGENDAMENTO eq 0) or (arguments.LIBERADA_AGENDAMENTO eq 1 and len(trim(arguments.TERCEIRIZADO) and arguments.TERCEIRIZADO eq 1))>
					<!--- Composio --->
                    <cfif Len(Trim(arguments.COMPOSICAO))>
                        <cfscript>
                            ret_comp = this.set_solicitacao_carga_comp(solicitacao_carga_id = arguments.SOLICITACAO_CARGA_ID,
                                                                       composicao 	 	    = arguments.COMPOSICAO,
                                                                       valida_veiculo 	    = 1);
                        </cfscript>
                        <cfif ret_comp.erro>
                            <cfthrow object="#ret_comp.mensagem#">
                        </cfif>
                    </cfif>
				</cfif>
               
                
                <!--- Desvincula os outros tipos de documento --->                    
				<cfscript>
                    ret_del_nfs = this.prc_del_sol_carga_nf_tipos(SOLICITACAO_CARGA_ID	= arguments.SOLICITACAO_CARGA_ID
					                                             ,TIPO_DOCUMENTO_ID		= arguments.tipo_documento_id);
                </cfscript>
                <cfif ret_del_nfs.erro>
                    <cfthrow object="#ret_del_nfs.mensagem#">
                </cfif>
                
				<cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <cfscript>
                            v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_NOTAS_FISCAIS');
                            v_numero 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_NUMERO_NOTAS_FISCAIS");
                            v_data_emissao       = this.ListaToArray(lista = arguments, variavel  = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                            v_serie 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_SERIE_NOTAS_FISCAIS");
                            v_sub_serie          = this.ListaToArray(lista = arguments, variavel  = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                            v_modelo             = this.ListaToArray(lista = arguments, variavel  = "NOTA_MODELO_NOTAS_FISCAIS");
                            v_valor_nf	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_NOTAS_FISCAIS");
                            v_valor_segurado     = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
                            v_peso               = this.ListaToArray(lista = arguments, variavel  = "NOTA_PESO_NOTAS_FISCAIS");
                            v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
                            v_qtde_volume        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
                            v_cod_unidade        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
                            v_m3                 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_M3_NOTAS_FISCAIS');
                            v_peso_cubado        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
                            v_num_natureza       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
                            v_natureza           = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NATUREZA_NOTAS_FISCAIS');
                            v_complemento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
                            v_num_especie        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
                            v_especie            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ESPECIE_NOTAS_FISCAIS');
                            v_altura             = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ALTURA_NOTAS_FISCAIS');
                            v_largura            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_LARGURA_NOTAS_FISCAIS');
                            v_comprimento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
                            v_cubagem            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
                            v_cfop				 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CFOP_NOTAS_FISCAIS');
							v_ordem_compra       = this.ListaToArray(lista = arguments, variavel  = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");							
                            v_excluir	  		 = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_solicitacao_carga_nf_id));
                        </cfscript>
                        
                        <cfloop list="#v_excluir#" delimiters="," index="c_id">
                            <cfscript>
                                ret_del_nf = this.del_solicitacao_carga_nf(SOLICITACAO_CARGA_NF_ID = c_id);
                            </cfscript>
                            <cfif ret_del_nf.erro>
                                <cfthrow object="#ret_del_nf.mensagem#">
                            </cfif>
                        </cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                            <cfscript>
                                if(Not Len(Trim(v_solicitacao_carga_nf_id[count]))) {
                                    ret_nf = this.ins_solicitacao_carga_nf(
									                                     solicitacao_carga_id			= arguments.solicitacao_carga_id,
                                                                         numero							= v_numero[count],
                                                                         data_emissao					= v_data_emissao[count],
                                                                         modelo							= v_modelo[count],
                                                                         serie							= v_serie[count],
                                                                         sub_serie						= v_sub_serie[count],
                                                                         valor_total					= v_valor_nf[count],
                                                                         nf_eletronica					= 0 ,
                                                                         valor_segurado					= v_valor_segurado[count],
                                                                         ordem_compra_cliente			= v_ordem_compra[count],
                                                                         peso							= v_peso[count],
                                                                         peso_cubado					= v_peso_cubado[count],
                                                                         peso_cobrado					= v_peso_cobrado[count],
                                                                         qtde_volume					= v_qtde_volume[count],
                                                                         altura							= v_altura[count],
                                                                         comprimento					= v_comprimento[count],
                                                                         largura						= v_largura[count],
                                                                         m3								= v_m3[count],
                                                                         cubagem						= v_cubagem[count],
                                                                         num_natureza					= v_num_natureza[count],
                                                                         complemento					= '',
                                                                         num_especie					= v_num_especie[count],
                                                                         cod_unidade					= v_cod_unidade[count],
                                                                         tipo_documento_id				= arguments.tipo_documento_id,
                                                                         num_romaneio					= '',
                                                                         valor_base_calculo_icms		= '',
                                                                         valor_icms						= '',
                                                                         valor_base_calculo_icms_st		= '',
                                                                         valor_icms_st					= '',
                                                                         valor_produtos					= '',
                                                                         cfop							= v_cfop[count],
                                                                         pin_suframa					= '',
                                                                         chave_acesso_nfe				= '',
                                                                         descricao_docto				= '',
                                                                         nfe_xml						= '');
                                }else{
                                    ret_nf = this.upd_solicitacao_carga_nf(SOLICITACAO_CARGA_NF_ID 		= v_solicitacao_carga_nf_id[count],
																		 solicitacao_carga_id			= arguments.solicitacao_carga_id,
                                                                         numero							= v_numero[count],
                                                                         data_emissao					= v_data_emissao[count],
                                                                         modelo							= v_modelo[count],
                                                                         serie							= v_serie[count],
                                                                         sub_serie						= v_sub_serie[count],
                                                                         valor_total					= v_valor_nf[count],
                                                                         nf_eletronica					= 0 ,
                                                                         valor_segurado					= v_valor_segurado[count],
                                                                         ordem_compra_cliente			= v_ordem_compra[count],
                                                                         peso							= v_peso[count],
                                                                         peso_cubado					= v_peso_cubado[count],
                                                                         peso_cobrado					= v_peso_cobrado[count],
                                                                         qtde_volume					= v_qtde_volume[count],
                                                                         altura							= v_altura[count],
                                                                         comprimento					= v_comprimento[count],
                                                                         largura						= v_largura[count],
                                                                         m3								= v_m3[count],
                                                                         cubagem						= v_cubagem[count],
                                                                         num_natureza					= v_num_natureza[count],
                                                                         complemento					= '',
                                                                         num_especie					= v_num_especie[count],
                                                                         cod_unidade					= v_cod_unidade[count],
                                                                         tipo_documento_id				= arguments.tipo_documento_id,
                                                                         num_romaneio					= '',
                                                                         valor_base_calculo_icms		= '',
                                                                         valor_icms						= '',
                                                                         valor_base_calculo_icms_st		= '',
                                                                         valor_icms_st					= '',
                                                                         valor_produtos					= '',
                                                                         cfop							= v_cfop[count],
                                                                         pin_suframa					= '',
                                                                         chave_acesso_nfe				= '',
                                                                         descricao_docto				= '',
                                                                         nfe_xml						= '');

                                }
                            </cfscript>
                            <cfif ret_nf.erro>
                                <cfthrow object="#ret_nf.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="1">
                         <!---Insere NFE --->
                        <cfscript>
                            v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_NFE');
                            v_nota_conhecimento     = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NFE");
                            v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nfe_valor_segurado	= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_SEGURADO");
                            v_pin_suframa_nfe		= this.ListaToArray (lista = arguments, variavel = "PIN_SUFRAMA_NFE_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
                            v_peso               	= this.ListaToArray(lista = arguments, variavel  = "NFE_PESO_NFE");
                            v_peso_cobrado       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_COBRADO_NFE');
                            v_qtde_volume        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COD_UNIDADE_NFE');
                            v_m3                 	= this.ListaToArray(lista = arguments, variavel  = 'NFE_M3_NFE');
                            v_peso_cubado        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_NATUREZA_NFE');
                            v_natureza           	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NATUREZA_NFE');
                            v_complemento        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_ESPECIE_NFE');
                            v_especie            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ESPECIE_NFE');
                            v_altura             	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ALTURA_NFE');
                            v_largura            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_LARGURA_NFE');
                            v_comprimento        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_CUBAGEM_NFE');
                            v_ordem_compra       	= this.ListaToArray(lista = arguments, variavel  = "NFE_ORDEM_COMPRA_NFE");
							v_nfe_xml				= this.ListaToArray(lista = arguments, variavel  = "NFE_XML_NFE");
							v_excluir	  			= this.ListDiff(lista1 = arguments.lista_deleted_NFE, lista2 = ArrayToList(v_solicitacao_carga_nf_id));
                        </cfscript>
                        
                        <cfloop list="#v_excluir#" delimiters="," index="c_id">
                            <cfscript>
                                ret_del_nf = this.del_solicitacao_carga_nf(SOLICITACAO_CARGA_NF_ID = c_id);
                            </cfscript>
                            <cfif ret_del_nf.erro>
                                <cfthrow object="#ret_del_nf.mensagem#">
                            </cfif>
                        </cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                             <!---Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                if(Not Len(Trim(v_solicitacao_carga_nf_id[count]))) {
                                    ret_nfe = this.ins_solicitacao_carga_nf(solicitacao_carga_id			= arguments.solicitacao_carga_id,
                                                                          numero						= v_numero[count],
                                                                          numero_old					= v_numero[count],
                                                                          data_emissao					= v_data_emissao[count],
                                                                          modelo						= v_modelo[count],
                                                                          serie							= v_serie[count],
                                                                          sub_serie						= '1',
                                                                          valor_total					= v_nfe_valor[count],
                                                                          nf_eletronica					= 1,
                                                                          valor_segurado				= v_nfe_valor_segurado[count],
                                                                          ordem_compra_cliente			= v_ordem_compra[count],
                                                                          peso							= v_peso[count],
                                                                          peso_cubado					= v_peso_cubado[count],
                                                                          peso_cobrado					= v_peso_cobrado[count],
                                                                          qtde_volume					= v_qtde_volume[count],
                                                                          altura						= v_altura[count],
                                                                          comprimento					= v_comprimento[count],
                                                                          largura						= v_largura[count],
                                                                          m3							= v_m3[count],
                                                                          cubagem						= v_cubagem[count],
                                                                          num_natureza					= v_num_natureza[count],
                                                                          complemento					= '',
                                                                          num_especie					= v_num_especie[count],
                                                                          cod_unidade					= v_cod_unidade[count],
                                                                          tipo_documento_id				= arguments.tipo_documento_id,
                                                                          num_romaneio					= '',
                                                                          valor_base_calculo_icms		= '',
                                                                          valor_icms					= '',
                                                                          valor_base_calculo_icms_st	= '',
                                                                          valor_icms_st					= '',
                                                                          valor_produtos				= '',
                                                                          cfop							= '',
                                                                          pin_suframa					= v_pin_suframa_nfe[count],
                                                                          chave_acesso_nfe				= v_chave_acesso_nfe[count],
                                                                          descricao_docto				= '',
                                                                          nfe_xml						= VARQUIVO,
                                                                          documento_id					= v_documento_id[count]);
                                }else{
                                    ret_nfe = this.upd_solicitacao_carga_nf(SOLICITACAO_CARGA_NF_ID 	= v_solicitacao_carga_nf_id[count],
																		    solicitacao_carga_id		= arguments.solicitacao_carga_id,
                                                                            numero						= v_numero[count],
                                                                            numero_old					= v_numero[count],
                                                                            data_emissao				= v_data_emissao[count],
                                                                            modelo						= v_modelo[count],
                                                                            serie						= v_serie[count],
                                                                            sub_serie					= '1',
                                                                            valor_total					= v_nfe_valor[count],
                                                                            nf_eletronica				= 1,
                                                                            valor_segurado				= v_nfe_valor_segurado[count],
                                                                            ordem_compra_cliente		= v_ordem_compra[count],
                                                                            peso						= v_peso[count],
                                                                            peso_cubado					= v_peso_cubado[count],
                                                                            peso_cobrado				= v_peso_cobrado[count],
                                                                            qtde_volume					= v_qtde_volume[count],
                                                                            altura						= v_altura[count],
                                                                            comprimento					= v_comprimento[count],
                                                                            largura						= v_largura[count],
                                                                            m3							= v_m3[count],
                                                                            cubagem						= v_cubagem[count],
                                                                            num_natureza				= v_num_natureza[count],
                                                                            complemento					= '',
                                                                            num_especie					= v_num_especie[count],
                                                                            cod_unidade					= v_cod_unidade[count],
                                                                            tipo_documento_id			= arguments.tipo_documento_id,
                                                                            num_romaneio				= '',
                                                                            valor_base_calculo_icms		= '',
                                                                            valor_icms					= '',
                                                                            valor_base_calculo_icms_st	= '',
                                                                            valor_icms_st				= '',
                                                                            valor_produtos				= '',
                                                                            cfop						= '',
                                                                            pin_suframa					= v_pin_suframa_nfe[count],
                                                                            chave_acesso_nfe			= v_chave_acesso_nfe[count],
                                                                            descricao_docto				= '',
                                                                            nfe_xml						= v_nfe_xml[count],
                                                                            documento_id				= v_documento_id[count]);
                                    
                                }
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>


                    <cfcase value="2">
                         <!---Insere Outros Documentos--->
                        <cfscript>
                            v_solicitacao_carga_nf_id = this.ListaToArray(lista = arguments, variavel = 'SOLICITACAO_CARGA_NF_ID_OUTROS');
                            v_outros_numero			  = this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	  = this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		  = this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			  = this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                    = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado            = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                      = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza            = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                  = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura                 = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento             = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem                 = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
							v_ordem_compra       	  = this.ListaToArray(lista = arguments, variavel  = "OUTROS_ORDEM_COMPRA_OUTROS");
							v_excluir	  			  = this.ListDiff(lista1 = arguments.lista_deleted_OUTROS, lista2 = ArrayToList(v_solicitacao_carga_nf_id));
                        </cfscript>
                        
                        <cfloop list="#v_excluir#" delimiters="," index="c_id">
                            <cfscript>
                                ret_del_nf = this.del_solicitacao_carga_nf(SOLICITACAO_CARGA_NF_ID = c_id);
                            </cfscript>
                            <cfif ret_del_nf.erro>
                                <cfthrow object="#ret_del_nf.mensagem#">
                            </cfif>
                        </cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                if(Not Len(Trim(v_solicitacao_carga_nf_id[count]))) {
                                    outros = this.ins_solicitacao_carga_nf(SOLICITACAO_CARGA_ID			= arguments.SOLICITACAO_CARGA_ID,
																		 numero							= v_outros_numero[count],
																		 numero_old						= v_outros_numero[count],
																		 data_emissao					= v_outros_data_emissao[count],
																		 modelo							= '01',
																		 serie							= 'U',
																		 sub_serie						= '1',
																		 valor_total					= v_outros_valor[count],
																		 nf_eletronica					= 0,
																		 valor_segurado					= v_outros_valor[count],
																		 ordem_compra_cliente			= v_ordem_compra[count],
																		 peso							= v_peso[count],
																		 peso_cubado					= v_peso_cubado[count],
																		 peso_cobrado					= v_peso_cobrado[count],
																		 qtde_volume					= v_qtde_volume[count],
																		 altura							= v_altura[count],
																		 comprimento					= v_comprimento[count],
																		 largura						= v_largura[count],
																		 m3								= v_m3[count],
																		 cubagem						= v_cubagem[count],
																		 num_natureza					= v_num_natureza[count],
																		 complemento					= '',
																		 num_especie					= v_num_especie[count],
																		 cod_unidade					= v_cod_unidade[count],
																		 tipo_documento_id				= arguments.tipo_documento_id,
																		 num_romaneio					= '',
																		 valor_base_calculo_icms		= '',
																		 valor_icms						= '',
																		 valor_base_calculo_icms_st		= '',
																		 valor_icms_st					= '',
																		 valor_produtos					= '',
																		 cfop							= '',
																		 pin_suframa					= '',
																		 chave_acesso_nfe				= '',
																		 descricao_docto				= v_outros_descricao[count],
																		 nfe_xml						= '');
                                }else{
                                    outros = this.upd_solicitacao_carga_nf(SOLICITACAO_CARGA_ID 		= arguments.SOLICITACAO_CARGA_ID,
																		 SOLICITACAO_CARGA_NF_ID		= v_solicitacao_carga_nf_id[count],
																		 numero							= v_outros_numero[count],
																		 numero_old						= v_outros_numero[count],
																		 data_emissao					= v_outros_data_emissao[count],
																		 modelo							= '01',
																		 serie							= 'U',
																		 sub_serie						= '1',
																		 valor_total					= v_outros_valor[count],
																		 nf_eletronica					= 0,
																		 valor_segurado					= v_outros_valor[count],
																		 ordem_compra_cliente			= v_ordem_compra[count],
																		 peso							= v_peso[count],
																		 peso_cubado					= v_peso_cubado[count],
																		 peso_cobrado					= v_peso_cobrado[count],
																		 qtde_volume					= v_qtde_volume[count],
																		 altura							= v_altura[count],
																		 comprimento					= v_comprimento[count],
																		 largura						= v_largura[count],
																		 m3								= v_m3[count],
																		 cubagem						= v_cubagem[count],
																		 num_natureza					= v_num_natureza[count],
																		 complemento					= '',
																		 num_especie					= v_num_especie[count],
																		 cod_unidade					= v_cod_unidade[count],
																		 tipo_documento_id				= arguments.tipo_documento_id,
																		 num_romaneio					= '',
																		 valor_base_calculo_icms		= '',
																		 valor_icms						= '',
																		 valor_base_calculo_icms_st		= '',
																		 valor_icms_st					= '',
																		 valor_produtos					= '',
																		 cfop							= '',
																		 pin_suframa					= '',
																		 chave_acesso_nfe				= '',
																		 descricao_docto				= v_outros_descricao[count],
																		 nfe_xml						= '');

                                }
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
                
                <!---- VINCULA O CRT a Solicitao de carga ----->
                <cfif Len(Trim(arguments.INTC_CONHECIMENTO_ID))>
                	<cfscript>
						ret_vinculo_crt = this.vincula_solicitacao_crt(solicitacao_carga_id         = arguments.SOLICITACAO_CARGA_ID,
 			  							                               conhecimento_id		        = arguments.INTC_CONHECIMENTO_ID);
					</cfscript>
					<cfif ret_vinculo_crt.erro>
                        <cfthrow object="#ret_vinculo_crt.mensagem#">
                    </cfif>
                </cfif>                
               
                <!--- Liberada p/ Agendamento --->
                <cfif (qrSolicitacao.LIBERADA_AGENDAMENTO eq 0 or (arguments.TERCEIRIZADO eq 1 and not len(trim(arguments.NUM_ROMANEIO)))) and arguments.LIBERADA_AGENDAMENTO eq 1>
                	<cfscript>
						ret_agen = this.liberar_agendamento_solic_carga(solicitacao_carga_id = arguments.SOLICITACAO_CARGA_ID,
						  										        gera_romaneio		 = arguments.GERA_ROMANEIO);
					</cfscript>
                    <cfif ret_agen.erro>
                        <cfthrow object="#ret_agen.mensagem#">
                    </cfif>
                </cfif>
                
                <!--- Verificar dados junto a Repom --->
                <cfscript>
					conn_repom = CreateComponent("_transportes.manipulacao.transporte.cfc_repom");
					ret_sol_rep = conn_repom.ins_solicit_carga_dados(solicitacao_carga_id = arguments.solicitacao_carga_id
														     	    ,cartao_numero	      = arguments.CARTAO_NUMERO
															 	   	,adto_trajeto_vazio   = arguments.ADTO_TRAJETO_VAZIO
															  		);
				</cfscript>
                <cfif ret_sol_rep.erro>
                    <cfthrow object="#ret_sol_rep.mensagem#">
                </cfif>

				<!--- Container <upd>--->
                <cfscript>
					v_container_id = -1;
               	</cfscript>
				<cfif arguments.POSSUI_MOVTO_CONTAINER eq 0 > <!--- No possui movimentao --->
    	           	<cfif not len(trim(arguments.CONTAINER_ID)) > <!--- No foi informado um container do sistema --->
	    	           	<cfif len(trim(arguments.CONTAINER_IDENTIFICADOR)) > <!--- Foi informado um container desconhecido. Cadastrar --->
            	        	<cfscript>
								ret_cad_ctn = ins_container_identificador(identificador = arguments.CONTAINER_IDENTIFICADOR
								                                         ,tipo_id		= arguments.CONTAINER_TIPO_ID);
							</cfscript>
							<cfif ret_cad_ctn.erro>
	                            <cfthrow object="#ret_cad_ctn.mensagem#">
                            <cfelse>
	                            <cfset v_container_id = ret_cad_ctn.CONTAINER_ID>
                            </cfif>
						</cfif>
					<cfelse> <!--- Foi informado um container do sistema --->
						<cfset v_container_id = arguments.CONTAINER_ID>
					</cfif>
					<cfif len(trim(v_container_id)) and v_container_id gt 0 > <!--- Tendo o container, consolidar e vincular  solicitao de carga: --->
                    	<cfscript>
							ret_cons_ctn = consolidar_container(container_id         = v_container_id
                                   							   ,carga_consolidada_id = arguments.CARGA_CONSOLIDADA_ID
												               ,origem_registro 	 = 'Manual');
						</cfscript>
						<cfif ret_cons_ctn.erro>
                            <cfthrow object="#ret_cons_ctn.mensagem#">
                        <cfelse> <!--- Se consolidou o container, vincula --->
                        	<cfscript>
								ret_it_ctn = ins_movto_container_it(movto_container_id   = ret_cons_ctn.MOVTO_CONTAINER_ID_GERADO
								                                   ,solicitacao_carga_id = arguments.SOLICITACAO_CARGA_ID);
							</cfscript>
							<cfif ret_it_ctn.erro>
	                            <cfthrow object="#ret_it_ctn.mensagem#">
                            </cfif>                            
                        </cfif>                        
					</cfif>                            
                </cfif>	<!---<cfif arguments.POSSUI_MOVTO_CONTAINER eq 0 > <!--- No possui movimentao --->--->                

				<!--- Valida situao da solicitao --->
				<cfscript>
					conn = CreateComponent("_transportes.consulta.logistica.cfc_solicitacao");
					qrSolicitacao = conn.get_solicitacao_carga(solicitacao_carga_id	= arguments.SOLICITACAO_CARGA_ID);
				</cfscript>
				<cfset retorno.SITUACAO_ID = qrSolicitacao.SITUACAO_ID>
				<cfset retorno.SOLICITACAO_CARGA_ID = arguments.SOLICITACAO_CARGA_ID>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de carga alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir cancelamento.
    -- jaquelinef 01/11/2013 14:17:37 - CRIADO
    --->
    <cffunction name='ins_cancelamento' displayname='Inserir cancelamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='no' default="">
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_cancelamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CANCELAMENTO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
            </cfstoredproc>         
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Cancelar Solicitao de Carga.
    -- jaquelinef 01/11/2013 14:21:03 - CRIADO
    --->
    <cffunction name='cancelar_solicitacao' displayname='Cancelar Solicitao de Carga.' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='MOTIVO' required='no' default="">        
        <cftry>
            <cftransaction action='begin'>
				<cfscript>
                    cancelamento = this.ins_cancelamento(descricao = arguments.MOTIVO);
                </cfscript>             
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_cancelar_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#cancelamento.CANCELAMENTO_ID#'  null='#iif(len(trim(cancelamento.CANCELAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao Cancelada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Cancela uma solicitao de carga
	-- ANDERSONC 22/09/2009 10:40:56 - CRIADO
	--->
	<cffunction name='can_solicitacao_carga' displayname='Cancela uma solicitao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='no' default='5'>
		<cfargument name='MOTIVO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicitacao_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao de carga cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui uma solicitacao de carga
    -- ANDERSONC 22/09/2009 10:38:12 - CRIADO
    --->
    <cffunction name='del_solicitacao_carga' displayname='Exclui uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_solicitacao_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de carga excluida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um acessorio na solicitacao de carga
    -- cristofer 12/05/2009 18:07:57 - CRIADO
    --->
    <cffunction name='ins_solicitacao_acessorio' displayname='Insere um acessorio na solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_acessorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Acessrio vinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um acessorio na solicitacao de carga
    -- cristofer 12/05/2009 18:08:39 - CRIADO
    --->
    <cffunction name='del_solicitacao_acessorio' displayname='Exclui um acessorio na solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_solicitacao_acessorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Acessrio desvinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um tipo de carroceria na solicitacao de carga
    -- cristofer 12/05/2009 18:09:41 - CRIADO
    --->
    <cffunction name='ins_solicitacao_tipo_carr' displayname='Insere um tipo de carroceria na solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_tipo_carr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de Carroceria vinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de carroceria na solicitacao de carga
    -- cristofer 12/05/2009 18:11:06 - CRIADO
    --->
    <cffunction name='del_solicitacao_tipo_carr' displayname='Exclui um tipo de carroceria na solicitacao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_solicitacao_tipo_carr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de Carroceria desvinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
	-- PROPSITO
    -- Gera um ACT
    -- ANDERSONC 27/05/2009 15:10:38 - CRIADO
	--->
    <cffunction name='gerar_carga_act' displayname='Gera um ACT' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='OBSERVACAO' required='no'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_gerar_carga_act' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('A.C.T. gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
   
     <!--- 
	-- PROPSITO
	-- Gera uma Coleta
	-- MARIALICE 09/09/2011 15:34:38 - CRIADO
	--->
    <cffunction name='gerar_carga_coleta' displayname='Gera uma Coleta' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='NUM_FORMULARIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_gerar_carga_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
               </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Coleta gerada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Libera para agendamento uma solicitacao de carga
	-- ANDERSONC 07/03/2011 - ALTERADO
	-- Alterado por FABIOG em 02/06/2011
	--->
	<cffunction name='liberar_agendamento_solic_carga' displayname='Libera para agendamento uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='GERA_AGENDAMENTO_AUTO' required='no' default='1'>
        <cfargument name='GERA_ROMANEIO' required='yes'>
        <cfargument name='SOLICITACAO_CARGA_ID_VINCULO' required='no' default=''>
		<cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_liberar_agend_solic_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERA_AGENDAMENTO_AUTO#'  null='#iif(len(trim(arguments.GERA_AGENDAMENTO_AUTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERA_ROMANEIO#'  null='#iif(len(trim(arguments.GERA_ROMANEIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID_VINCULO#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID_VINCULO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Solicitao de carga liberada para agendamento com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!--- 
	-- PROPSITO
	-- Vincula agendamento ao CRT
	-- GUTO 01/02/2013
	--->
	<cffunction name='vincula_solicitacao_crt' displayname='Libera para agendamento uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='no' default='1'>
		<cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_carga_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Solicitao vinculada com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Estorna a liberao de agendamento de uma solicitacao de carga
	-- ANDERSONC 09/09/2009 17:22:43 - CRIADO
	--->
	<cffunction name='estornar_agendamento_solic_carga' displayname='Estorna a liberao de agendamento de uma solicitacao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_estornar_agend_solic_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat(retorno.MENSAGEM)>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Vincula uma solicitao de carga a um agendamento
    -- ANDERSONC 02/02/2010 17:03:15 - CRIADO
    --->
    <cffunction name='vincula_solic_agendamento' displayname='Vincula uma solicitao de carga a um agendamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_agendamento.prc_vincula_solic_agendamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de carga vinculada com sucesso ao agendamento n ' & arguments.VIAGEM_ID & '.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere uma nota fiscal  uma solicitao de carga
    -- ANDERSONC 24/09/2009 11:03:00 - CRIADO
    --->
    <cffunction name='ins_solicitacao_carga_nf' displayname='Insere uma nota fiscal  solicitao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='NUMERO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='MODELO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='SUB_SERIE' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='VALOR_SEGURADO' required='yes'>
        <cfargument name='ORDEM_COMPRA_CLIENTE' required='yes'>
        <cfargument name='QTDE_VOLUME' required='yes'>
        <cfargument name='PESO' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='NUM_ESPECIE' required='yes'>
        <cfargument name='ALTURA' required='yes'>
        <cfargument name='COMPRIMENTO' required='yes'>
        <cfargument name='LARGURA' required='yes'>
        <cfargument name='CUBAGEM' required='yes'>
        <cfargument name='M3' required='yes'>
        <cfargument name='PESO_CUBADO' required='yes'>
        <cfargument name='PESO_COBRADO' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CHAVE_ACESSO_NFE' required='yes'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
        <cfargument name='DESCRICAO_DOCTO' required='yes'>
        <cfargument name='VALOR_BASE_CALCULO_ICMS' required='yes'>
        <cfargument name='VALOR_ICMS' required='yes'>
        <cfargument name='VALOR_BASE_CALCULO_ICMS_ST' required='yes'>
        <cfargument name='VALOR_ICMS_ST' required='yes'>
        <cfargument name='VALOR_PRODUTOS' required='yes'>
        <cfargument name='PIN_SUFRAMA' required='yes'>
        <cfargument name='DOCUMENTO_ID' required='no' default="">
        <cfargument name='NF_ELETRONICA' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cfargument name='NFE_XML' required='no' default="">
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_ins_solicitacao_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_CARGA_NF_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUB_SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORDEM_COMPRA_CLIENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CFOP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE_ACESSO_NFE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_DOCTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS_ST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_ICMS_ST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PRODUTOS#'  null='#iif(len(trim(arguments.VALOR_PRODUTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PIN_SUFRAMA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NF_ELETRONICA#'  null='#iif(len(trim(arguments.NF_ELETRONICA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.NFE_XML#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota Fiscal inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
-- PROPSITO
    -- Altera uma nota fiscal de uma solicitao de carga
    -- ANDERSONC 24/09/2009 11:04:53 - CRIADO
--->
    <cffunction name='upd_solicitacao_carga_nf' displayname='Altera uma nota fiscal de uma solicitao de carga' access='remote' returntype='Struct' output='true'>
	<cfargument name='SOLICITACAO_CARGA_NF_ID' required='yes'>
	<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
	<cfargument name='NUMERO' required='yes'>
	<cfargument name='DATA_EMISSAO' required='yes'>
	<cfargument name='MODELO' required='yes'>
	<cfargument name='SERIE' required='yes'>
	<cfargument name='SUB_SERIE' required='yes'>
	<cfargument name='VALOR_TOTAL' required='yes'>
	<cfargument name='VALOR_SEGURADO' required='yes'>
	<cfargument name='ORDEM_COMPRA_CLIENTE' required='yes'>
	<cfargument name='QTDE_VOLUME' required='yes'>
	<cfargument name='PESO' required='yes'>
	<cfargument name='COD_UNIDADE' required='yes'>
	<cfargument name='NUM_NATUREZA' required='yes'>
	<cfargument name='NUM_ESPECIE' required='yes'>
	<cfargument name='ALTURA' required='yes'>
	<cfargument name='COMPRIMENTO' required='yes'>
	<cfargument name='LARGURA' required='yes'>
	<cfargument name='CUBAGEM' required='yes'>
	<cfargument name='M3' required='yes'>
	<cfargument name='PESO_CUBADO' required='yes'>
	<cfargument name='PESO_COBRADO' required='yes'>
	<cfargument name='CFOP' required='yes'>
	<cfargument name='CHAVE_ACESSO_NFE' required='yes'>
	<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
	<cfargument name='DESCRICAO_DOCTO' required='yes'>
	<cfargument name='VALOR_BASE_CALCULO_ICMS' required='yes'>
	<cfargument name='VALOR_ICMS' required='yes'>
	<cfargument name='VALOR_BASE_CALCULO_ICMS_ST' required='yes'>
	<cfargument name='VALOR_ICMS_ST' required='yes'>
	<cfargument name='VALOR_PRODUTOS' required='yes'>
	<cfargument name='PIN_SUFRAMA' required='yes'>
	<cfargument name='DOCUMENTO_ID' required='no' default="">
	<cfargument name='NF_ELETRONICA' required='yes'>
	<cfargument name='COMPLEMENTO' required='yes'>
    <cfargument name='NFE_XML' required='no' default="">
	<cftry>
			<cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicitacao_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_NF_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_NF_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUB_SERIE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORDEM_COMPRA_CLIENTE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CFOP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE_ACESSO_NFE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_DOCTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS_ST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_ICMS_ST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PRODUTOS#'  null='#iif(len(trim(arguments.VALOR_PRODUTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PIN_SUFRAMA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NF_ELETRONICA#'  null='#iif(len(trim(arguments.NF_ELETRONICA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.NFE_XML#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota Fiscal alterada com sucesso.')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma nota fiscal de uma solicitao de carga
    -- ANDERSONC 24/09/2009 11:05:48 - CRIADO
    --->
    <cffunction name='del_solicitacao_carga_nf' displayname='Exclui uma nota fiscal de uma solicitao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_NF_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_solicitacao_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_NF_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_NF_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota Fiscal excluda com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar Ordem de Lavagem
	-- RAFAEL 29/03/2010 14:16:38 - CRIADO
	--->
	<cffunction name='gerar_ordem_lavagem' displayname='Gerar Ordem de Lavagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='COD_FORNECEDOR' required='yes'>
		<cfargument name='APARENCIA' required='no' default="0">
		<cfargument name='COMPLETA' required='no' default="0">
		<cfargument name='LAVAGEM_INTERNA' required='no' default="0">
		<cfargument name='LAVAGEM_EXTERNA' required='no' default="0">
		<cfargument name='OUTROS' required='no' default="0">
		<cfargument name='DESCRICAO_OUTROS' required='no' default="">
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        
        <cfargument name='EQUIPAMENTO_ID_TRACAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID_REFERENCIA' required='no' default="-1">
        
		<cfargument name='COD_SOLICITANTE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					connM = CreateComponent("_transportes.consulta.cfc_manutencao");
					qrVeiculoTracao  = connM.get_veiculo_equipamento(equipamento_id = arguments.EQUIPAMENTO_ID_TRACAO);
					if(IsDefined("arguments.EQUIPAMENTO_ID_REFERENCIA") and Len(Trim(arguments.EQUIPAMENTO_ID_REFERENCIA))){
						qrVeiculoCarreta = connM.get_veiculo_equipamento(equipamento_id = arguments.EQUIPAMENTO_ID_REFERENCIA);
						v_carreta = qrVeiculoCarreta.VEICULO_ID;
					}else{
						v_carreta = '';
					}
                </cfscript>
                
                <cfstoredproc procedure='logistica.pkg_ordem_lavagem.prc_ins_ordem_lavagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ORDEM_LAVAGEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.APARENCIA#'  null='#iif(len(trim(arguments.APARENCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPLETA#'  null='#iif(len(trim(arguments.COMPLETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAVAGEM_INTERNA#'  null='#iif(len(trim(arguments.LAVAGEM_INTERNA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LAVAGEM_EXTERNA#'  null='#iif(len(trim(arguments.LAVAGEM_EXTERNA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OUTROS#'  null='#iif(len(trim(arguments.OUTROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_OUTROS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#qrVeiculoTracao.VEICULO_ID#'  null='#iif(len(trim(qrVeiculoTracao.VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_carreta#'  null='#iif(len(trim(v_carreta)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SOLICITANTE#'  null='#iif(len(trim(arguments.COD_SOLICITANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ATIVIDADE_ID#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de Lavagem gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Alterar a composio e o motorista da solicitao.
    -- ANDERSONC 04/08/2010 17:48:12 - CRIADO
    --->
    <cffunction name='alt_solicit_motorista_comp' displayname='Alterar a composio e o motorista da solicitao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_solicitacao.prc_alt_solicit_motorista_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPOSICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de carga alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Destina um agendamento com os seus dados
	-- ANDERSONC 07/03/2011 15:33:12 - CRIADO
	--->
	<cffunction name='destinar_viagem' displayname='Destina um agendamento com os seus dados' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_agendamento.prc_destinar_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
                
                <cfset v_num_romaneio = ''>
                
                <cfscript>
                	connRomaneio     = CreateComponent("modulos.pcl._componentes.consulta.cfc_solicitacao");
                	qrRomaneioViagem = connRomaneio.get_romaneio_viagem(viagem_id = arguments.viagem_id);
					v_num_romaneio   = qrRomaneioViagem.NUM_ROMANEIO;
                </cfscript>
                
				<cfset retorno.mensagem = JSStringFormat('Agendamento destinado com sucesso. Romaneio ' & v_num_romaneio & '.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar as Notas Ficais vinculadas a solicitao de Carga e que sejam do9 tipo de Documento diferente do parametro
	-- RAFAEL 17/08/2012 18:03:11 - CRIADO
	--->
	<cffunction name='prc_del_sol_carga_nf_tipos' displayname='Deletar as Notas Ficais vinculadas a solicitao de Carga e que sejam do9 tipo de Documento diferente do parametro' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='logistica.pkg_solicitacao.prc_del_sol_carga_nf_tipos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
        
	<!--- 
    -- PROPSITO
    -- Gerar ordem de coleta
    -- guto 29/11/2013 15:35:11 - CRIADO
    --->
    <cffunction name='gera_ordem_coleta' displayname='Gerar ordem de coleta' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_ordem_carregamento.prc_gerar_ordem_carregamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ordem de coleta gerada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir vnculo entre solicitao de carga e pr ordem
	-- rafael 10/09/2014 22:13:32 - CRIADO
	--->
	<cffunction name='ins_pre_ordem_sol_carga' displayname='Inserir vnculo entre solicitao de carga e pr ordem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRE_ORDEM_ID' required='yes'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='grisco.pkg_pre_ordem.prc_ins_pre_ordem_sol_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRE_ORDEM_ID#'  null='#iif(len(trim(arguments.PRE_ORDEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
		    <cfset retorno.mensagem = JSStringFormat('')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancelar vnculo entre solicitao de carga e pr ordem
	-- rafael 11/09/2014 00:04:04 - CRIADO
	--->
	<cffunction name='can_pre_ordem_sol_carga' displayname='Cancelar vnculo entre solicitao de carga e pr ordem' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_pre_ordem.prc_can_pre_ordem_sol_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Aprova operao de segundo trecho.
    -- IVANRIBEIRO 31/03/2015 15:55:59 - CRIADO
    --->
    <cffunction name='aprovar_seg_trecho' displayname='Aprova operao de segundo trecho.' access='remote' returntype='Struct' output='true'>
        <cfargument name='OP_TRECHO_APROVA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='logistica.pkg_operacao.prc_aprovar_seg_trecho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OP_TRECHO_APROVA_ID#'  null='#iif(len(trim(arguments.OP_TRECHO_APROVA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao de segundo trecho aprovada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Rejeita operao de segundo trecho.
	-- IVANRIBEIRO 31/03/2015 17:23:18 - CRIADO
	--->
	<cffunction name='rejeitar_seg_trecho' displayname='Rejeita operao de segundo trecho.' access='remote' returntype='Struct' output='true'>
		<cfargument name='OP_TRECHO_APROVA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_operacao.prc_desaprovar_seg_trecho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OP_TRECHO_APROVA_ID#'  null='#iif(len(trim(arguments.OP_TRECHO_APROVA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operao de segundo trecho rejeitada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
